using System;
using System.Xml;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// This class represents setup and introductory text 
	/// request message defined in VistALink protocol.
	/// </summary>
	public sealed class SecuritySetupAndIntroRequestMessage : SecuritySimpleRequestMessage
	{
		/// <summary>
		/// VistALink message request type string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string RequestType = "AV.SetupAndIntroText";

		/// <summary>
		/// Default parameterless constructor: setup and introductory text request 
		/// security message does not require any parameters to be created.
		/// </summary>
		public SecuritySetupAndIntroRequestMessage() 
			: base( RequestType ) {}

		/// <summary>
		/// Standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="sourceDoc">Source XML document.</param>
		public SecuritySetupAndIntroRequestMessage( XmlDocument sourceDoc ) 
			: base( RequestType, sourceDoc ) {}
	}
}
